export interface ReviewData {
  id: string;
  author: { nl: string; en: string };
  avatar: string;
  content: { nl: string; en: string };
  rating: number;
  timestamp: { nl: string; en: string };
}

export const eventReviewsData: { [key: string]: ReviewData[] } = {
  '1': [
    {
      id: 'r1',
      author: { nl: 'Sarah van Dijk', en: 'Sarah van Dijk' },
      avatar: '👩',
      content: { 
        nl: 'Geweldig festival! Fantastische sfeer en veel diversiteit in het programma.',
        en: 'Great festival! Fantastic atmosphere and lots of diversity in the program.'
      },
      rating: 5,
      timestamp: { nl: '2 dagen geleden', en: '2 days ago' }
    },
    {
      id: 'r2',
      author: { nl: 'Tom de Boer', en: 'Tom de Boer' },
      avatar: '👨',
      content: { 
        nl: 'Leuk evenement, maar het was wel erg druk. Volgende keer eerder komen!',
        en: 'Nice event, but it was very crowded. Come earlier next time!'
      },
      rating: 4,
      timestamp: { nl: '3 dagen geleden', en: '3 days ago' }
    },
    {
      id: 'r3',
      author: { nl: 'Fatima Akram', en: 'Fatima Akram' },
      avatar: '👩‍🦱',
      content: { 
        nl: 'Mooie muziek en gezellige mensen. Zeker een aanrader!',
        en: 'Beautiful music and friendly people. Definitely recommended!'
      },
      rating: 5,
      timestamp: { nl: '4 dagen geleden', en: '4 days ago' }
    }
  ],
  '2': [
    {
      id: 'r4',
      author: { nl: 'Pieter Jansen', en: 'Pieter Jansen' },
      avatar: '👨‍🦳',
      content: { 
        nl: 'Mooie kunst en leuke gesprekken met kunstenaars.',
        en: 'Beautiful art and nice conversations with artists.'
      },
      rating: 5,
      timestamp: { nl: '1 week geleden', en: '1 week ago' }
    },
    {
      id: 'r5',
      author: { nl: 'Nina Martinez', en: 'Nina Martinez' },
      avatar: '👩',
      content: { 
        nl: 'Geweldige plek om unieke kunstwerken te vinden!',
        en: 'Great place to find unique artworks!'
      },
      rating: 4,
      timestamp: { nl: '1 week geleden', en: '1 week ago' }
    },
    {
      id: 'r6',
      author: { nl: 'Alex Chen', en: 'Alex Chen' },
      avatar: '👨',
      content: { 
        nl: 'Goede kwaliteit, maar prijzen zijn aan de hoge kant.',
        en: 'Good quality, but prices are on the high side.'
      },
      rating: 3,
      timestamp: { nl: '2 weken geleden', en: '2 weeks ago' }
    }
  ],
  '3': [
    {
      id: 'r7',
      author: { nl: 'Eva Bakker', en: 'Eva Bakker' },
      avatar: '👩',
      content: { 
        nl: 'Zeer informatieve rondleiding! De gids kende de geschiedenis goed.',
        en: 'Very informative tour! The guide knew the history well.'
      },
      rating: 5,
      timestamp: { nl: '3 weken geleden', en: '3 weeks ago' }
    },
    {
      id: 'r8',
      author: { nl: 'Marco Visser', en: 'Marco Visser' },
      avatar: '👨',
      content: { 
        nl: 'Interessant, maar het duurde wat lang.',
        en: 'Interesting, but it took a bit long.'
      },
      rating: 3,
      timestamp: { nl: '3 weken geleden', en: '3 weeks ago' }
    },
    {
      id: 'r9',
      author: { nl: 'Linda Smeets', en: 'Linda Smeets' },
      avatar: '👩',
      content: { 
        nl: 'Perfecte manier om Amsterdam te verkennen!',
        en: 'Perfect way to explore Amsterdam!'
      },
      rating: 5,
      timestamp: { nl: '4 weken geleden', en: '4 weeks ago' }
    }
  ],
  '4': [
    {
      id: 'r10',
      author: { nl: 'David Berg', en: 'David Berg' },
      avatar: '👨',
      content: { 
        nl: 'Ongelooflijke line-up! Beste muziekfestival van het jaar.',
        en: 'Incredible lineup! Best music festival of the year.'
      },
      rating: 5,
      timestamp: { nl: '1 dag geleden', en: '1 day ago' }
    },
    {
      id: 'r11',
      author: { nl: 'Anna Kowalski', en: 'Anna Kowalski' },
      avatar: '👩',
      content: { 
        nl: 'Geweldige sfeer en organisatie was top!',
        en: 'Great atmosphere and organization was top notch!'
      },
      rating: 5,
      timestamp: { nl: '2 dagen geleden', en: '2 days ago' }
    },
    {
      id: 'r12',
      author: { nl: 'Hassan Ibrahim', en: 'Hassan Ibrahim' },
      avatar: '👨',
      content: { 
        nl: 'Leuk festival, maar geluid was soms te hard.',
        en: 'Nice festival, but sound was sometimes too loud.'
      },
      rating: 4,
      timestamp: { nl: '3 dagen geleden', en: '3 days ago' }
    }
  ],
  '5': [
    {
      id: 'r13',
      author: { nl: 'Sophie Laurent', en: 'Sophie Laurent' },
      avatar: '👩',
      content: { 
        nl: 'Prachtige collectie boeken tegen goede prijzen!',
        en: 'Beautiful collection of books at good prices!'
      },
      rating: 5,
      timestamp: { nl: '2 weken geleden', en: '2 weeks ago' }
    },
    {
      id: 'r14',
      author: { nl: 'Jan Pietersen', en: 'Jan Pietersen' },
      avatar: '👨',
      content: { 
        nl: 'Veel keuze, maar wel erg druk.',
        en: 'Lots of choice, but very crowded.'
      },
      rating: 4,
      timestamp: { nl: '2 weken geleden', en: '2 weeks ago' }
    },
    {
      id: 'r15',
      author: { nl: 'Elena Popov', en: 'Elena Popov' },
      avatar: '👩',
      content: { 
        nl: 'Vond een paar zeldzame exemplaren! Aanrader.',
        en: 'Found some rare copies! Recommended.'
      },
      rating: 5,
      timestamp: { nl: '3 weken geleden', en: '3 weeks ago' }
    }
  ],
  '6': [
    {
      id: 'r16',
      author: { nl: 'Robert Johnson', en: 'Robert Johnson' },
      avatar: '👨',
      content: { 
        nl: 'Romantische avond met een geweldige film!',
        en: 'Romantic evening with a great movie!'
      },
      rating: 5,
      timestamp: { nl: '1 dag geleden', en: '1 day ago' }
    },
    {
      id: 'r17',
      author: { nl: 'Yasmin Ali', en: 'Yasmin Ali' },
      avatar: '👩',
      content: { 
        nl: 'Heerlijk om zo buiten een film te kijken!',
        en: 'Lovely to watch a movie outside like this!'
      },
      rating: 5,
      timestamp: { nl: '2 dagen geleden', en: '2 days ago' }
    },
    {
      id: 'r18',
      author: { nl: 'Michael Wong', en: 'Michael Wong' },
      avatar: '👨',
      content: { 
        nl: 'Leuk concept, maar geluid kon beter.',
        en: 'Nice concept, but sound could be better.'
      },
      rating: 3,
      timestamp: { nl: '3 dagen geleden', en: '3 days ago' }
    }
  ],
  '7': [
    {
      id: 'r19',
      author: { nl: 'Karin de Groot', en: 'Karin de Groot' },
      avatar: '👩',
      content: { 
        nl: 'Perfect voor het hele gezin! Kinderen vermaakten zich prima.',
        en: 'Perfect for the whole family! Children had a great time.'
      },
      rating: 5,
      timestamp: { nl: '1 maand geleden', en: '1 month ago' }
    },
    {
      id: 'r20',
      author: { nl: 'Tim Vos', en: 'Tim Vos' },
      avatar: '👨',
      content: { 
        nl: 'Goede organisatie en veel verschillende activiteiten.',
        en: 'Good organization and many different activities.'
      },
      rating: 4,
      timestamp: { nl: '1 maand geleden', en: '1 month ago' }
    },
    {
      id: 'r21',
      author: { nl: 'Priya Sharma', en: 'Priya Sharma' },
      avatar: '👩',
      content: { 
        nl: 'Leuk initiatief van de gemeente!',
        en: 'Nice initiative from the municipality!'
      },
      rating: 5,
      timestamp: { nl: '1 maand geleden', en: '1 month ago' }
    }
  ],
  '8': [
    {
      id: 'r22',
      author: { nl: 'Carlos Rodriguez', en: 'Carlos Rodriguez' },
      avatar: '👨',
      content: { 
        nl: 'Heerlijk eten van over de hele wereld! Aanrader!',
        en: 'Delicious food from all over the world! Recommended!'
      },
      rating: 5,
      timestamp: { nl: '1 dag geleden', en: '1 day ago' }
    },
    {
      id: 'r23',
      author: { nl: 'Julia Novak', en: 'Julia Novak' },
      avatar: '👩',
      content: { 
        nl: 'Geweldige variatie aan gerechten en gezellige sfeer.',
        en: 'Great variety of dishes and cozy atmosphere.'
      },
      rating: 5,
      timestamp: { nl: '2 dagen geleden', en: '2 days ago' }
    },
    {
      id: 'r24',
      author: { nl: 'Ahmed Khalil', en: 'Ahmed Khalil' },
      avatar: '👨',
      content: { 
        nl: 'Lekker eten maar wel prijzig.',
        en: 'Tasty food but quite pricey.'
      },
      rating: 4,
      timestamp: { nl: '3 dagen geleden', en: '3 days ago' }
    }
  ],
  '9': [
    {
      id: 'r25',
      author: { nl: 'Isabella Costa', en: 'Isabella Costa' },
      avatar: '👩',
      content: { 
        nl: 'Prachtige voorstelling met geweldige acteurs!',
        en: 'Beautiful performance with great actors!'
      },
      rating: 5,
      timestamp: { nl: '1 dag geleden', en: '1 day ago' }
    },
    {
      id: 'r26',
      author: { nl: 'Marcus de Jong', en: 'Marcus de Jong' },
      avatar: '👨',
      content: { 
        nl: 'Indrukwekkend! Aanrader voor theaterliefhebbers.',
        en: 'Impressive! Recommended for theater lovers.'
      },
      rating: 5,
      timestamp: { nl: '2 dagen geleden', en: '2 days ago' }
    },
    {
      id: 'r27',
      author: { nl: 'Nadia Osman', en: 'Nadia Osman' },
      avatar: '👩',
      content: { 
        nl: 'Goede voorstelling, maar het was koud buiten.',
        en: 'Good performance, but it was cold outside.'
      },
      rating: 4,
      timestamp: { nl: '3 dagen geleden', en: '3 days ago' }
    }
  ],
  '10': [
    {
      id: 'r28',
      author: { nl: 'Hans Mulder', en: 'Hans Mulder' },
      avatar: '👨',
      content: { 
        nl: 'Heerlijke kerstsfeer met leuke kraampjes!',
        en: 'Wonderful Christmas atmosphere with nice stalls!'
      },
      rating: 5,
      timestamp: { nl: '1 dag geleden', en: '1 day ago' }
    },
    {
      id: 'r29',
      author: { nl: 'Sofie Andersen', en: 'Sofie Andersen' },
      avatar: '👩',
      content: { 
        nl: 'Perfect voor kerst shopping en glühwein!',
        en: 'Perfect for Christmas shopping and mulled wine!'
      },
      rating: 5,
      timestamp: { nl: '2 dagen geleden', en: '2 days ago' }
    },
    {
      id: 'r30',
      author: { nl: 'Omar Farah', en: 'Omar Farah' },
      avatar: '👨',
      content: { 
        nl: 'Gezellig, maar wel erg druk.',
        en: 'Cozy, but very crowded.'
      },
      rating: 4,
      timestamp: { nl: '3 dagen geleden', en: '3 days ago' }
    }
  ],
  '12': [
    {
      id: 'r31',
      author: { nl: 'Laura Bianchi', en: 'Laura Bianchi' },
      avatar: '👩',
      content: { 
        nl: 'Fantastische jazz muziek bij zonsondergang!',
        en: 'Fantastic jazz music at sunset!'
      },
      rating: 5,
      timestamp: { nl: '1 dag geleden', en: '1 day ago' }
    },
    {
      id: 'r32',
      author: { nl: 'Daniel Schmidt', en: 'Daniel Schmidt' },
      avatar: '👨',
      content: { 
        nl: 'Geweldige muzikanten en prachtige locatie.',
        en: 'Great musicians and beautiful location.'
      },
      rating: 5,
      timestamp: { nl: '2 dagen geleden', en: '2 days ago' }
    },
    {
      id: 'r33',
      author: { nl: 'Amira Hassan', en: 'Amira Hassan' },
      avatar: '👩',
      content: { 
        nl: 'Mooie avond, maar te weinig zitplaatsen.',
        en: 'Nice evening, but too few seats.'
      },
      rating: 4,
      timestamp: { nl: '3 dagen geleden', en: '3 days ago' }
    }
  ],
  '13': [
    {
      id: 'r34',
      author: { nl: 'Viktor Petrov', en: 'Viktor Petrov' },
      avatar: '👨',
      content: { 
        nl: 'Geweldige vintage vondsten!',
        en: 'Great vintage finds!'
      },
      rating: 5,
      timestamp: { nl: '2 weken geleden', en: '2 weeks ago' }
    },
    {
      id: 'r35',
      author: { nl: 'Emma Larsen', en: 'Emma Larsen' },
      avatar: '👩',
      content: { 
        nl: 'Leuke spullen maar wel duur.',
        en: 'Nice items but expensive.'
      },
      rating: 3,
      timestamp: { nl: '2 weken geleden', en: '2 weeks ago' }
    },
    {
      id: 'r36',
      author: { nl: 'Oscar Fernandez', en: 'Oscar Fernandez' },
      avatar: '👨',
      content: { 
        nl: 'Unieke stukken, zeker de moeite waard!',
        en: 'Unique pieces, definitely worth it!'
      },
      rating: 5,
      timestamp: { nl: '3 weken geleden', en: '3 weeks ago' }
    }
  ],
  '14': [
    {
      id: 'r37',
      author: { nl: 'Vera Jansen', en: 'Vera Jansen' },
      avatar: '👩',
      content: { 
        nl: 'Prachtig evenement! Mooie speech van de burgemeester.',
        en: 'Beautiful event! Nice speech from the mayor.'
      },
      rating: 5,
      timestamp: { nl: '1 dag geleden', en: '1 day ago' }
    },
    {
      id: 'r38',
      author: { nl: 'Johan van Berg', en: 'Johan van Berg' },
      avatar: '👨',
      content: { 
        nl: 'Goed georganiseerd en mooie ontmoeting met buren.',
        en: 'Well organized and nice meeting with neighbors.'
      },
      rating: 5,
      timestamp: { nl: '1 dag geleden', en: '1 day ago' }
    },
    {
      id: 'r39',
      author: { nl: 'Laila Ahmed', en: 'Laila Ahmed' },
      avatar: '👩',
      content: { 
        nl: 'Mooi initiatief van de gemeente!',
        en: 'Nice initiative from the municipality!'
      },
      rating: 5,
      timestamp: { nl: '2 dagen geleden', en: '2 days ago' }
    }
  ],
  '15': [
    {
      id: 'r40',
      author: { nl: 'Finn Johansen', en: 'Finn Johansen' },
      avatar: '👨',
      content: { 
        nl: 'Heerlijk schaatsen! Baan is goed onderhouden.',
        en: 'Great skating! Rink is well maintained.'
      },
      rating: 5,
      timestamp: { nl: '1 dag geleden', en: '1 day ago' }
    },
    {
      id: 'r41',
      author: { nl: 'Mila Kovač', en: 'Mila Kovač' },
      avatar: '👩',
      content: { 
        nl: 'Perfect voor kinderen en volwassenen!',
        en: 'Perfect for children and adults!'
      },
      rating: 5,
      timestamp: { nl: '2 dagen geleden', en: '2 days ago' }
    },
    {
      id: 'r42',
      author: { nl: 'Ibrahim Yilmaz', en: 'Ibrahim Yilmaz' },
      avatar: '👨',
      content: { 
        nl: 'Leuk, maar schaatsverhuur is duur.',
        en: 'Nice, but skate rental is expensive.'
      },
      rating: 4,
      timestamp: { nl: '3 dagen geleden', en: '3 days ago' }
    }
  ],
  '16': [
    {
      id: 'r43',
      author: { nl: 'Olivia Taylor', en: 'Olivia Taylor' },
      avatar: '👩',
      content: { 
        nl: 'Leerzame workshop voor beginners!',
        en: 'Educational workshop for beginners!'
      },
      rating: 5,
      timestamp: { nl: '1 maand geleden', en: '1 month ago' }
    },
    {
      id: 'r44',
      author: { nl: 'Lucas Santos', en: 'Lucas Santos' },
      avatar: '👨',
      content: { 
        nl: 'Goede uitleg en leuke sfeer.',
        en: 'Good explanation and nice atmosphere.'
      },
      rating: 4,
      timestamp: { nl: '1 maand geleden', en: '1 month ago' }
    },
    {
      id: 'r45',
      author: { nl: 'Zara Khan', en: 'Zara Khan' },
      avatar: '👩',
      content: { 
        nl: 'Nuttige tips gekregen!',
        en: 'Received useful tips!'
      },
      rating: 5,
      timestamp: { nl: '1 maand geleden', en: '1 month ago' }
    }
  ],
  '17': [
    {
      id: 'r46',
      author: { nl: 'Gustav Hansen', en: 'Gustav Hansen' },
      avatar: '👨',
      content: { 
        nl: 'Heerlijk kerstdiner met de buurt!',
        en: 'Delicious Christmas dinner with the neighborhood!'
      },
      rating: 5,
      timestamp: { nl: '1 dag geleden', en: '1 day ago' }
    },
    {
      id: 'r47',
      author: { nl: 'Aisha Mohamed', en: 'Aisha Mohamed' },
      avatar: '👩',
      content: { 
        nl: 'Gezellig samenzijn en lekker eten.',
        en: 'Cozy gathering and delicious food.'
      },
      rating: 5,
      timestamp: { nl: '1 dag geleden', en: '1 day ago' }
    },
    {
      id: 'r48',
      author: { nl: 'Thomas Müller', en: 'Thomas Müller' },
      avatar: '👨',
      content: { 
        nl: 'Mooie kerstsfeer en vriendelijke mensen.',
        en: 'Beautiful Christmas atmosphere and friendly people.'
      },
      rating: 5,
      timestamp: { nl: '2 dagen geleden', en: '2 days ago' }
    }
  ],
  '18': [
    {
      id: 'r49',
      author: { nl: 'Nora Blomqvist', en: 'Nora Blomqvist' },
      avatar: '👩',
      content: { 
        nl: 'Ontspannende wandeling door mooie parken!',
        en: 'Relaxing walk through beautiful parks!'
      },
      rating: 5,
      timestamp: { nl: '2 maanden geleden', en: '2 months ago' }
    },
    {
      id: 'r50',
      author: { nl: 'Rafael Silva', en: 'Rafael Silva' },
      avatar: '👨',
      content: { 
        nl: 'Mooie herfstk  kleuren en goede gids.',
        en: 'Beautiful autumn colors and good guide.'
      },
      rating: 5,
      timestamp: { nl: '2 maanden geleden', en: '2 months ago' }
    },
    {
      id: 'r51',
      author: { nl: 'Sana Ali', en: 'Sana Ali' },
      avatar: '👩',
      content: { 
        nl: 'Perfecte manier om de natuur te ervaren.',
        en: 'Perfect way to experience nature.'
      },
      rating: 5,
      timestamp: { nl: '2 maanden geleden', en: '2 months ago' }
    }
  ]
};
