export interface EventData {
  id: string;
  name: { nl: string; en: string };
  description: { nl: string; en: string };
  age: 'new' | 'old';
  verification: 'verified' | 'trusted' | 'unverified';
  position: { x: number; y: number };
  category: { nl: string; en: string };
  date: string;
}

export const eventsData: EventData[] = [
  {
    id: '1',
    name: { nl: 'Straatfestival Centrum', en: 'Street Festival Center' },
    description: { nl: 'Jaarlijks straatfestival in het centrum van Amsterdam', en: 'Annual street festival in the center of Amsterdam' },
    age: 'new',
    verification: 'verified',
    position: { x: 48, y: 38 },
    category: { nl: 'Festival', en: 'Festival' },
    date: '21/12/2024'
  },
  {
    id: '2',
    name: { nl: 'Kunstmarkt Jordaan', en: 'Art Market Jordaan' },
    description: { nl: 'Maandelijkse kunstmarkt in de Jordaan', en: 'Monthly art market in the Jordaan' },
    age: 'old',
    verification: 'trusted',
    position: { x: 25, y: 45 },
    category: { nl: 'Markt', en: 'Market' },
    date: '28/09/2024'
  },
  {
    id: '3',
    name: { nl: 'Historische rondleiding', en: 'Historical Tour' },
    description: { nl: 'Rondleiding door historisch Amsterdam', en: 'Tour through historic Amsterdam' },
    age: 'old',
    verification: 'unverified',
    position: { x: 18, y: 68 },
    category: { nl: 'Cultuur', en: 'Culture' },
    date: '15/08/2024'
  },
  {
    id: '4',
    name: { nl: 'Muziekfestival Oost', en: 'Music Festival East' },
    description: { nl: 'Zomers muziekfestival in Amsterdam Oost', en: 'Summer music festival in Amsterdam East' },
    age: 'new',
    verification: 'verified',
    position: { x: 70, y: 50 },
    category: { nl: 'Muziek', en: 'Music' },
    date: '24/12/2024'
  },
  {
    id: '5',
    name: { nl: 'Boekenmarkt', en: 'Book Market' },
    description: { nl: 'Tweedehands boekenmarkt bij het water', en: 'Second-hand book market by the water' },
    age: 'old',
    verification: 'trusted',
    position: { x: 60, y: 25 },
    category: { nl: 'Markt', en: 'Market' },
    date: '05/10/2024'
  },
  {
    id: '6',
    name: { nl: 'Filmavond park', en: 'Park Movie Night' },
    description: { nl: 'Openlucht filmvoorstelling in het Vondelpark', en: 'Outdoor film screening in Vondelpark' },
    age: 'new',
    verification: 'verified',
    position: { x: 20, y: 60 },
    category: { nl: 'Film', en: 'Film' },
    date: '27/12/2024'
  },
  {
    id: '7',
    name: { nl: 'Sportdag West', en: 'Sports Day West' },
    description: { nl: 'Gemeentelijke sportdag voor alle leeftijden', en: 'Municipal sports day for all ages' },
    age: 'old',
    verification: 'verified',
    position: { x: 22, y: 48 },
    category: { nl: 'Sport', en: 'Sports' },
    date: '12/07/2024'
  },
  {
    id: '8',
    name: { nl: 'Food festival Zuid', en: 'Food Festival South' },
    description: { nl: 'Internationale food trucks festival', en: 'International food truck festival' },
    age: 'new',
    verification: 'trusted',
    position: { x: 50, y: 70 },
    category: { nl: 'Food', en: 'Food' },
    date: '28/12/2024'
  },
  {
    id: '9',
    name: { nl: 'Theater voorstelling', en: 'Theater Performance' },
    description: { nl: 'Openlucht theatervoorstelling in het stadspark', en: 'Outdoor theater performance in the city park' },
    age: 'new',
    verification: 'verified',
    position: { x: 35, y: 55 },
    category: { nl: 'Theater', en: 'Theater' },
    date: '31/12/2024'
  },
  {
    id: '10',
    name: { nl: 'Kerstmarkt Noord', en: 'Christmas Market North' },
    description: { nl: 'Gezellige kerstmarkt met lokale kraampjes', en: 'Cozy Christmas market with local stalls' },
    age: 'new',
    verification: 'trusted',
    position: { x: 65, y: 15 },
    category: { nl: 'Markt', en: 'Market' },
    date: '20/12/2024'
  },
  {
    id: '12',
    name: { nl: 'Jazz concert', en: 'Jazz Concert' },
    description: { nl: 'Live jazz muziek aan het water', en: 'Live jazz music by the water' },
    age: 'new',
    verification: 'verified',
    position: { x: 52, y: 48 },
    category: { nl: 'Muziek', en: 'Music' },
    date: '23/12/2024'
  },
  {
    id: '13',
    name: { nl: 'Vintage markt', en: 'Vintage Market' },
    description: { nl: 'Tweedehands kleding en antiek', en: 'Second-hand clothing and antiques' },
    age: 'old',
    verification: 'trusted',
    position: { x: 30, y: 75 },
    category: { nl: 'Markt', en: 'Market' },
    date: '03/11/2024'
  },
  {
    id: '14',
    name: { nl: 'Nieuwjaarsreceptie', en: 'New Year Reception' },
    description: { nl: 'Gemeente nieuwjaarsreceptie voor alle bewoners', en: 'Municipal New Year reception for all residents' },
    age: 'new',
    verification: 'verified',
    position: { x: 52, y: 42 },
    category: { nl: 'Gemeente', en: 'Municipality' },
    date: '01/01/2025'
  },
  {
    id: '15',
    name: { nl: 'Schaatsbaan opening', en: 'Ice Rink Opening' },
    description: { nl: 'Opening van de tijdelijke ijsbaan in de wijk', en: 'Opening of the temporary ice rink in the neighborhood' },
    age: 'new',
    verification: 'verified',
    position: { x: 75, y: 65 },
    category: { nl: 'Sport', en: 'Sports' },
    date: '26/12/2024'
  },
  {
    id: '16',
    name: { nl: 'Workshop fotografie', en: 'Photography Workshop' },
    description: { nl: 'Gratis fotografie workshop voor beginners', en: 'Free photography workshop for beginners' },
    age: 'old',
    verification: 'unverified',
    position: { x: 35, y: 32 },
    category: { nl: 'Workshop', en: 'Workshop' },
    date: '22/09/2024'
  },
  {
    id: '17',
    name: { nl: 'Kerstdiner buurtcentrum', en: 'Christmas Dinner Community Center' },
    description: { nl: 'Gezamenlijk kerstdiner in het buurtcentrum', en: 'Joint Christmas dinner at the community center' },
    age: 'new',
    verification: 'trusted',
    position: { x: 62, y: 58 },
    category: { nl: 'Sociaal', en: 'Social' },
    date: '25/12/2024'
  },
  {
    id: '18',
    name: { nl: 'Herfstwandeling', en: 'Autumn Walk' },
    description: { nl: 'Begeleide wandeling door de parken', en: 'Guided walk through the parks' },
    age: 'old',
    verification: 'verified',
    position: { x: 42, y: 68 },
    category: { nl: 'Natuur', en: 'Nature' },
    date: '14/10/2024'
  }
];

export interface DiscussionData {
  id: string;
  neighborhood: { nl: string; en: string };
  hashtag: string;
  topic: { nl: string; en: string };
  position: { x: number; y: number };
}

export const discussionsData: DiscussionData[] = [
  {
    id: 'd1',
    neighborhood: { nl: 'Haarlemmerbuurt', en: 'Haarlemmerbuurt' },
    hashtag: '#Haarlemmerbuurt',
    topic: { nl: 'Afval op straat moet opgeruimd worden', en: 'Street waste needs to be cleaned up' },
    position: { x: 30, y: 28 }
  },
  {
    id: 'd2',
    neighborhood: { nl: 'Kattenburgerwijk', en: 'Kattenburgerwijk' },
    hashtag: '#Kattenburgerwijk',
    topic: { nl: 'Meer groen in de wijk', en: 'More greenery in the neighborhood' },
    position: { x: 65, y: 40 }
  },
  {
    id: 'd3',
    neighborhood: { nl: 'De Pijp', en: 'De Pijp' },
    hashtag: '#DePijp',
    topic: { nl: 'Verbetering speelplaatsen', en: 'Playground improvements' },
    position: { x: 45, y: 65 }
  }
];
