export interface CommentData {
  id: string;
  author: { nl: string; en: string };
  avatar: string;
  content: { nl: string; en: string };
  timestamp: { nl: string; en: string };
}

export const discussionCommentsData: { [key: string]: CommentData[] } = {
  'd1': [
    {
      id: 'c1',
      author: { nl: 'Jan de Vries', en: 'Jan de Vries' },
      avatar: '👨',
      content: { 
        nl: 'Het is echt een probleem geworden, vooral bij de hoek van de Haarlemmerstraat. Kunnen we hier een actieplan voor maken?',
        en: 'It has really become a problem, especially at the corner of Haarlemmerstraat. Can we make an action plan for this?'
      },
      timestamp: { nl: '2 uur geleden', en: '2 hours ago' }
    },
    {
      id: 'c2',
      author: { nl: 'Maria Jansen', en: 'Maria Jansen' },
      avatar: '👩',
      content: { 
        nl: 'Ik ben het helemaal met je eens! Misschien kunnen we ook meer afvalbakken plaatsen?',
        en: 'I completely agree with you! Maybe we can also place more trash bins?'
      },
      timestamp: { nl: '1 uur geleden', en: '1 hour ago' }
    },
    {
      id: 'c3',
      author: { nl: 'Ahmed Hassan', en: 'Ahmed Hassan' },
      avatar: '👨‍🦱',
      content: { 
        nl: 'Goed idee! Ik zou ook willen helpen met een opruimactie dit weekend.',
        en: 'Good idea! I would also like to help with a cleanup action this weekend.'
      },
      timestamp: { nl: '30 minuten geleden', en: '30 minutes ago' }
    }
  ],
  'd2': [
    {
      id: 'c4',
      author: { nl: 'Sophie van Dam', en: 'Sophie van Dam' },
      avatar: '👩‍🦰',
      content: { 
        nl: 'We hebben echt meer groen nodig in onze wijk. De kinderen hebben nergens om te spelen.',
        en: 'We really need more greenery in our neighborhood. The children have nowhere to play.'
      },
      timestamp: { nl: '3 uur geleden', en: '3 hours ago' }
    },
    {
      id: 'c5',
      author: { nl: 'Peter Bakker', en: 'Peter Bakker' },
      avatar: '👨‍🦳',
      content: { 
        nl: 'Kunnen we misschien een paar bomen planten bij het plein?',
        en: 'Can we perhaps plant some trees at the square?'
      },
      timestamp: { nl: '2 uur geleden', en: '2 hours ago' }
    },
    {
      id: 'c6',
      author: { nl: 'Lisa Chen', en: 'Lisa Chen' },
      avatar: '👩',
      content: { 
        nl: 'Ik heb contact gehad met de gemeente, ze staan open voor voorstellen!',
        en: 'I have been in contact with the municipality, they are open to suggestions!'
      },
      timestamp: { nl: '1 uur geleden', en: '1 hour ago' }
    }
  ],
  'd3': [
    {
      id: 'c7',
      author: { nl: 'Robert Smit', en: 'Robert Smit' },
      avatar: '👨',
      content: { 
        nl: 'De speelplaats bij de school is echt aan vervanging toe.',
        en: 'The playground at the school really needs to be replaced.'
      },
      timestamp: { nl: '4 uur geleden', en: '4 hours ago' }
    },
    {
      id: 'c8',
      author: { nl: 'Emma de Wit', en: 'Emma de Wit' },
      avatar: '👩',
      content: { 
        nl: 'Mijn kinderen spelen daar elke dag, het is inderdaad niet veilig meer.',
        en: 'My children play there every day, it is indeed no longer safe.'
      },
      timestamp: { nl: '3 uur geleden', en: '3 hours ago' }
    },
    {
      id: 'c9',
      author: { nl: 'Mohammed Ali', en: 'Mohammed Ali' },
      avatar: '👨',
      content: { 
        nl: 'Kunnen we een petitie starten? Ik denk dat veel ouders dit steunen.',
        en: 'Can we start a petition? I think many parents will support this.'
      },
      timestamp: { nl: '2 uur geleden', en: '2 hours ago' }
    }
  ]
};
