import { ZoomIn, ZoomOut } from 'lucide-react';

interface ZoomControlProps {
  zoom: number;
  onZoomChange: (zoom: number) => void;
  onResetView: () => void;
}

export function ZoomControl({ zoom, onZoomChange, onResetView }: ZoomControlProps) {
  const handleZoomChange = (newZoom: number) => {
    onZoomChange(Math.max(0, Math.min(100, newZoom)));
  };

  return (
    <div className="absolute bottom-6 right-6 z-30 bg-white rounded-lg shadow-lg p-4 border border-gray-200">
      <div className="flex flex-col items-center gap-3">
        <button
          onClick={() => handleZoomChange(zoom + 10)}
          className="p-2 hover:bg-gray-100 rounded transition-colors"
          title="Inzoomen"
        >
          <ZoomIn className="w-5 h-5 text-gray-700" />
        </button>
        
        <div className="flex items-center gap-2">
          <input
            type="range"
            min="0"
            max="100"
            value={zoom}
            onChange={(e) => handleZoomChange(Number(e.target.value))}
            className="h-24 w-2 appearance-none bg-gray-200 rounded-lg cursor-pointer"
            orient="vertical"
            style={{
              writingMode: 'vertical-lr',
              direction: 'rtl',
              background: `linear-gradient(to top, #3B82F6 0%, #3B82F6 ${zoom}%, #E5E7EB ${zoom}%, #E5E7EB 100%)`
            }}
          />
        </div>
        
        <button
          onClick={() => handleZoomChange(zoom - 10)}
          className="p-2 hover:bg-gray-100 rounded transition-colors"
          title="Uitzoomen"
        >
          <ZoomOut className="w-5 h-5 text-gray-700" />
        </button>
        
        <div className="text-xs text-gray-600 mt-2">
          {zoom}%
        </div>
        
        <button
          onClick={onResetView}
          className="text-xs text-blue-600 hover:text-blue-700 mt-1"
        >
          Reset
        </button>
      </div>
    </div>
  );
}