import { Check, Map, Satellite, Bus, Leaf } from 'lucide-react';
import { translations } from '../translations';

interface ViewOptionsMenuProps {
  mapType: 'standard' | 'satellite' | 'transit';
  setMapType: (type: 'standard' | 'satellite' | 'transit') => void;
  ecoMode: boolean;
  setEcoMode: (enabled: boolean) => void;
  onClose: () => void;
  language: 'nl' | 'en';
}

export function ViewOptionsMenu({
  mapType,
  setMapType,
  ecoMode,
  setEcoMode,
  onClose,
  language
}: ViewOptionsMenuProps) {
  const t = translations[language].viewOptionsMenu;

  return (
    <>
      <div className="fixed inset-0 z-40" onClick={onClose} />
      <div className="absolute top-full mt-2 right-0 bg-white border border-gray-200 rounded shadow-lg w-64 z-50">
        <div className="p-2">
          <div className="px-3 py-2 text-sm text-gray-500">{t.title}</div>
          
          <button
            onClick={() => setMapType('standard')}
            className="w-full flex items-center justify-between px-3 py-2 hover:bg-gray-100 rounded"
          >
            <span className="flex items-center gap-2 text-sm">
              <Map className="w-4 h-4 text-gray-600" />
              {t.standard}
            </span>
            {mapType === 'standard' && <Check className="w-4 h-4 text-orange-500" />}
          </button>
          
          <button
            onClick={() => setMapType('satellite')}
            className="w-full flex items-center justify-between px-3 py-2 hover:bg-gray-100 rounded"
          >
            <span className="flex items-center gap-2 text-sm">
              <Satellite className="w-4 h-4 text-gray-600" />
              {t.satellite}
            </span>
            {mapType === 'satellite' && <Check className="w-4 h-4 text-orange-500" />}
          </button>
          
          <button
            onClick={() => setMapType('transit')}
            className="w-full flex items-center justify-between px-3 py-2 hover:bg-gray-100 rounded"
          >
            <span className="flex items-center gap-2 text-sm">
              <Bus className="w-4 h-4 text-gray-600" />
              {t.transit}
            </span>
            {mapType === 'transit' && <Check className="w-4 h-4 text-orange-500" />}
          </button>

          <div className="border-t border-gray-200 my-2" />

          <div className="px-3 py-2">
            <div className="flex items-center gap-2 mb-2">
              <Leaf className="w-4 h-4 text-green-600" />
              <span className="text-sm text-gray-700">{t.ecoMode}</span>
            </div>
            <label className="flex items-center gap-2 cursor-pointer ml-6">
              <input
                type="checkbox"
                checked={ecoMode}
                onChange={(e) => setEcoMode(e.target.checked)}
                className="w-4 h-4 text-orange-500 border-gray-300 rounded focus:ring-orange-500"
              />
              <span className="text-sm text-gray-700">
                {t.ecoModeDescription}
              </span>
            </label>
          </div>
        </div>
      </div>
    </>
  );
}