export function TransitLines() {
  return (
    <svg
      className="absolute inset-0 w-full h-full pointer-events-none"
      style={{ zIndex: 5 }}
      viewBox="0 0 100 100"
      preserveAspectRatio="none"
    >
      {/* Metro Line 50 (Noord-Zuid lijn) - Verticaal door centrum */}
      <path
        d="M 50 25 L 50 85"
        stroke="#FFB800"
        strokeWidth="0.8"
        fill="none"
        strokeLinecap="round"
      />
      
      {/* Metro Line 51 (Oost-West) - Horizontaal door centrum */}
      <path
        d="M 20 45 L 75 45"
        stroke="#E60000"
        strokeWidth="0.8"
        fill="none"
        strokeLinecap="round"
      />
      
      {/* Metro Line 52 (Ring Zuid) */}
      <path
        d="M 25 70 Q 50 75, 70 70"
        stroke="#00A8E1"
        strokeWidth="0.8"
        fill="none"
        strokeLinecap="round"
      />
      
      {/* Metro Line 53 (Ring Noord) */}
      <path
        d="M 25 30 Q 50 28, 70 30"
        stroke="#8B4513"
        strokeWidth="0.8"
        fill="none"
        strokeLinecap="round"
      />
      
      {/* Metro Line 54 (Diagonaal NO-ZW) */}
      <path
        d="M 25 25 L 75 75"
        stroke="#00B388"
        strokeWidth="0.8"
        fill="none"
        strokeLinecap="round"
      />
      
      {/* Tram Line 1 - Door centrum naar Zuid */}
      <path
        d="M 45 28 Q 47 50, 45 78"
        stroke="#0066CC"
        strokeWidth="0.6"
        fill="none"
        strokeLinecap="round"
        strokeDasharray="1,0.5"
      />
      
      {/* Tram Line 2 - West naar Oost via centrum */}
      <path
        d="M 22 50 Q 50 48, 73 50"
        stroke="#0066CC"
        strokeWidth="0.6"
        fill="none"
        strokeLinecap="round"
        strokeDasharray="1,0.5"
      />
      
      {/* Tram Line 5 - Diagonaal NW-ZO */}
      <path
        d="M 28 28 L 72 72"
        stroke="#0066CC"
        strokeWidth="0.6"
        fill="none"
        strokeLinecap="round"
        strokeDasharray="1,0.5"
      />
      
      {/* Tram Line 7 - Ring rondom centrum */}
      <path
        d="M 32 35 L 68 35 L 68 65 L 32 65 Z"
        stroke="#0066CC"
        strokeWidth="0.6"
        fill="none"
        strokeLinecap="round"
        strokeDasharray="1,0.5"
      />
      
      {/* Bus Line 22 - Noord naar Zuid */}
      <path
        d="M 55 27 Q 57 50, 55 82"
        stroke="#CC0000"
        strokeWidth="0.5"
        fill="none"
        strokeLinecap="round"
        strokeDasharray="0.5,0.3"
      />
      
      {/* Bus Line 48 - West naar Oost */}
      <path
        d="M 23 40 Q 50 42, 74 40"
        stroke="#CC0000"
        strokeWidth="0.5"
        fill="none"
        strokeLinecap="round"
        strokeDasharray="0.5,0.3"
      />
      
      {/* Bus Line 65 - Diagonaal */}
      <path
        d="M 26 26 L 74 74"
        stroke="#CC0000"
        strokeWidth="0.5"
        fill="none"
        strokeLinecap="round"
        strokeDasharray="0.5,0.3"
      />
      
      {/* Bus Line 170 - Zuid ring */}
      <path
        d="M 28 73 Q 50 76, 68 73"
        stroke="#CC0000"
        strokeWidth="0.5"
        fill="none"
        strokeLinecap="round"
        strokeDasharray="0.5,0.3"
      />
      
      {/* Bus Line 21 - Noord ring */}
      <path
        d="M 28 27 Q 50 24, 68 27"
        stroke="#CC0000"
        strokeWidth="0.5"
        fill="none"
        strokeLinecap="round"
        strokeDasharray="0.5,0.3"
      />

      {/* Station markers - Centraal Station en belangrijke knooppunten */}
      <circle cx="50" cy="28" r="1.2" fill="white" stroke="#333" strokeWidth="0.3" />
      <circle cx="50" cy="50" r="1.5" fill="white" stroke="#333" strokeWidth="0.4" />
      <circle cx="30" cy="50" r="1" fill="white" stroke="#333" strokeWidth="0.3" />
      <circle cx="70" cy="50" r="1" fill="white" stroke="#333" strokeWidth="0.3" />
      <circle cx="50" cy="75" r="1.2" fill="white" stroke="#333" strokeWidth="0.3" />
      <circle cx="35" cy="35" r="0.8" fill="white" stroke="#333" strokeWidth="0.2" />
      <circle cx="65" cy="35" r="0.8" fill="white" stroke="#333" strokeWidth="0.2" />
      <circle cx="35" cy="65" r="0.8" fill="white" stroke="#333" strokeWidth="0.2" />
      <circle cx="65" cy="65" r="0.8" fill="white" stroke="#333" strokeWidth="0.2" />
    </svg>
  );
}