import { X, Shield } from 'lucide-react';
import { translations } from '../translations';

interface RulesModalProps {
  onClose: () => void;
  language: 'nl' | 'en';
}

export function RulesModal({ onClose, language }: RulesModalProps) {
  const t = translations[language].rulesModal;

  return (
    <div className="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50 p-4">
      <div className="bg-white rounded-lg shadow-xl max-w-3xl w-full p-6 relative max-h-[80vh] overflow-y-auto">
        <button
          onClick={onClose}
          className="absolute top-4 right-4 p-2 hover:bg-gray-100 rounded-full z-10"
        >
          <X className="w-5 h-5" />
        </button>

        <div className="mb-6">
          <div className="flex items-center gap-3 mb-2">
            <Shield className="w-6 h-6 text-blue-600" />
            <h2 className="text-gray-900">{t.title}</h2>
          </div>
          <p className="text-sm text-gray-600 mt-2">
            {t.subtitle}
          </p>
        </div>

        <div className="space-y-4">
          {/* Rule 1 */}
          <div className="bg-green-50 border border-green-200 rounded-lg p-4">
            <div className="flex items-start gap-3">
              <span className="text-2xl">✅</span>
              <div>
                <h3 className="text-sm text-gray-900 mb-1">{t.allowed}</h3>
                <p className="text-sm text-gray-700">{t.rule1}</p>
              </div>
            </div>
          </div>

          {/* Rule 2 */}
          <div className="bg-green-50 border border-green-200 rounded-lg p-4">
            <div className="flex items-start gap-3">
              <span className="text-2xl">✅</span>
              <div>
                <h3 className="text-sm text-gray-900 mb-1">{t.allowed}</h3>
                <p className="text-sm text-gray-700">{t.rule2}</p>
              </div>
            </div>
          </div>

          {/* Rule 3 */}
          <div className="bg-green-50 border border-green-200 rounded-lg p-4">
            <div className="flex items-start gap-3">
              <span className="text-2xl">✅</span>
              <div>
                <h3 className="text-sm text-gray-900 mb-1">{t.allowed}</h3>
                <p className="text-sm text-gray-700">{t.rule3}</p>
              </div>
            </div>
          </div>

          {/* Rule 4 */}
          <div className="bg-green-50 border border-green-200 rounded-lg p-4">
            <div className="flex items-start gap-3">
              <span className="text-2xl">✅</span>
              <div>
                <h3 className="text-sm text-gray-900 mb-1">{t.allowed}</h3>
                <p className="text-sm text-gray-700">{t.rule4}</p>
              </div>
            </div>
          </div>

          {/* Rule 5 - Warning */}
          <div className="bg-red-50 border border-red-200 rounded-lg p-4">
            <div className="flex items-start gap-3">
              <span className="text-2xl">⚠️</span>
              <div>
                <h3 className="text-sm text-gray-900 mb-1">{t.notAllowed}</h3>
                <p className="text-sm text-gray-700">{t.rule5}</p>
              </div>
            </div>
          </div>

          {/* Inclusivity */}
          <div className="bg-purple-50 border border-purple-200 rounded-lg p-4">
            <h3 className="text-sm text-gray-900 mb-2 flex items-center gap-2">
              <span className="text-xl">🌍</span>
              <span className="font-semibold">{t.subgroupsTitle}</span>
            </h3>
            <p className="text-sm text-gray-700 ml-7">{t.inclusivity}</p>
          </div>

          {/* Democratic Process */}
          <div className="bg-orange-50 border border-orange-200 rounded-lg p-4">
            <h3 className="text-sm text-gray-900 mb-2 flex items-center gap-2">
              <span className="text-xl">🗳️</span>
              <span className="font-semibold">{t.ruleChangesTitle}</span>
            </h3>
            <p className="text-sm text-gray-700 ml-7">{t.democraticProcess}</p>
          </div>
        </div>

        {/* Conflict Resolution Section */}
        <div className="mt-6 pt-6 border-t border-gray-200">
          <h3 className="text-gray-900 mb-4 flex items-center gap-2">
            <span className="text-xl">⚖️</span>
            {t.conflictTitle}
          </h3>
          
          <div className="space-y-3">
            <div className="bg-blue-50 border border-blue-200 rounded-lg p-4">
              <div className="flex items-start gap-3">
                <span className="text-lg">1️⃣</span>
                <p className="text-sm text-gray-700">{t.conflict1}</p>
              </div>
            </div>

            <div className="bg-blue-50 border border-blue-200 rounded-lg p-4">
              <div className="flex items-start gap-3">
                <span className="text-lg">2️⃣</span>
                <p className="text-sm text-gray-700">{t.conflict2}</p>
              </div>
            </div>
          </div>
        </div>

        <div className="mt-6 pt-4 border-t border-gray-200">
          <button
            onClick={onClose}
            className="w-full px-4 py-2 bg-blue-600 text-white rounded-lg hover:bg-blue-700"
          >
            {t.close}
          </button>
        </div>
      </div>
    </div>
  );
}