import { Search, Calendar, MapPin, Users, Verified, AlertCircle, ShieldAlert } from 'lucide-react';

interface LegendProps {
  mapType?: 'standard' | 'satellite' | 'transit';
}

export function Legend({ mapType }: LegendProps) {
  return (
    <div className="mt-4 space-y-4">
      <div>
        <h3 className="text-sm text-gray-900 mb-2">Plaatsingsdatum evenement</h3>
        <div className="space-y-2">
          <div className="flex items-center gap-2">
            <div className="w-4 h-4 rounded-full bg-green-500 border-2 border-white shadow" />
            <span className="text-xs text-gray-600">Nieuw evenement</span>
          </div>
          <div className="flex items-center gap-2">
            <div className="w-4 h-4 rounded-full bg-red-500 border-2 border-white shadow" />
            <span className="text-xs text-gray-600">Verouderd evenement</span>
          </div>
        </div>
      </div>

      <div>
        <h3 className="text-sm text-gray-900 mb-2">Verificatie status</h3>
        <div className="space-y-2">
          <div className="flex items-center gap-2">
            <Verified className="w-4 h-4 text-green-500" />
            <span className="text-xs text-gray-600">Gemeente geverifieerd</span>
          </div>
          <div className="flex items-center gap-2">
            <AlertCircle className="w-4 h-4 text-orange-500" />
            <span className="text-xs text-gray-600">Betrouwbare aanbieder</span>
          </div>
          <div className="flex items-center gap-2">
            <ShieldAlert className="w-4 h-4 text-red-500" />
            <span className="text-xs text-gray-600">Niet geverifieerd</span>
          </div>
        </div>
      </div>

      <div>
        <h3 className="text-sm text-gray-900 mb-2">Type markers</h3>
        <div className="space-y-2">
          <div className="flex items-center gap-2">
            <Calendar className="w-4 h-4 text-gray-600" />
            <span className="text-xs text-gray-600">Evenement</span>
          </div>
          <div className="flex items-center gap-2">
            <Users className="w-4 h-4 text-gray-600" />
            <span className="text-xs text-gray-600">Wijkdiscussie</span>
          </div>
        </div>
      </div>

      {/* OV Legenda - alleen zichtbaar bij transit weergave */}
      {mapType === 'transit' && (
        <div>
          <h3 className="text-sm text-gray-900 mb-2">Openbaar Vervoer</h3>
          <div className="space-y-2">
            <div className="flex items-center gap-2">
              <div className="w-8 h-1 bg-[#FFB800] rounded" />
              <span className="text-xs text-gray-600">Metro</span>
            </div>
            <div className="flex items-center gap-2">
              <div className="w-8 h-1 bg-[#0066CC] rounded" style={{ backgroundImage: 'repeating-linear-gradient(90deg, #0066CC 0, #0066CC 4px, transparent 4px, transparent 6px)' }} />
              <span className="text-xs text-gray-600">Tram</span>
            </div>
            <div className="flex items-center gap-2">
              <div className="w-8 h-1 bg-[#CC0000] rounded" style={{ backgroundImage: 'repeating-linear-gradient(90deg, #CC0000 0, #CC0000 3px, transparent 3px, transparent 5px)' }} />
              <span className="text-xs text-gray-600">Bus</span>
            </div>
            <div className="flex items-center gap-2">
              <div className="w-3 h-3 rounded-full bg-white border-2 border-gray-700" />
              <span className="text-xs text-gray-600">Station</span>
            </div>
          </div>
        </div>
      )}
    </div>
  );
}