import { useState } from 'react';
import { ChevronDown } from 'lucide-react';

interface LanguageSelectorProps {
  language: 'nl' | 'en';
  setLanguage: (lang: 'nl' | 'en') => void;
}

export function LanguageSelector({ language, setLanguage }: LanguageSelectorProps) {
  const [showDropdown, setShowDropdown] = useState(false);

  const languages = [
    { code: 'nl' as const, name: 'Nederlands', flag: '🇳🇱' },
    { code: 'en' as const, name: 'English', flag: '🇬🇧' }
  ];

  const currentLanguage = languages.find(lang => lang.code === language)!;

  return (
    <div className="relative">
      <button
        onClick={() => setShowDropdown(!showDropdown)}
        className="flex items-center gap-2 px-3 py-2 bg-white border border-gray-300 rounded hover:bg-gray-50 min-w-[140px]"
      >
        <span className="text-xl">{currentLanguage.flag}</span>
        <span className="text-sm">{currentLanguage.name}</span>
        <ChevronDown className="w-4 h-4 ml-auto" />
      </button>

      {showDropdown && (
        <>
          <div 
            className="fixed inset-0 z-10" 
            onClick={() => setShowDropdown(false)}
          />
          <div className="absolute top-full mt-2 right-0 bg-white border border-gray-200 rounded-lg shadow-lg overflow-hidden z-20 min-w-[140px]">
            {languages.map((lang) => (
              <button
                key={lang.code}
                onClick={() => {
                  setLanguage(lang.code);
                  setShowDropdown(false);
                }}
                className={`w-full flex items-center gap-2 px-4 py-2.5 hover:bg-gray-50 transition-colors ${
                  language === lang.code ? 'bg-orange-50' : ''
                }`}
              >
                <span className="text-xl">{lang.flag}</span>
                <span className="text-sm">{lang.name}</span>
              </button>
            ))}
          </div>
        </>
      )}
    </div>
  );
}
