import { X, Users } from 'lucide-react';
import { translations } from '../translations';

interface CommunityGovernanceModalProps {
  onClose: () => void;
  language: 'nl' | 'en';
}

export function CommunityGovernanceModal({ onClose, language }: CommunityGovernanceModalProps) {
  const t = translations[language].communityGovernanceModal;

  return (
    <div className="fixed inset-0 bg-black bg-opacity-50 flex items-center justify-center z-50 p-4">
      <div className="bg-white rounded-lg shadow-xl max-w-3xl w-full p-6 relative max-h-[80vh] overflow-y-auto">
        <button
          onClick={onClose}
          className="absolute top-4 right-4 p-2 hover:bg-gray-100 rounded-full z-10"
        >
          <X className="w-5 h-5" />
        </button>

        <div className="mb-6">
          <div className="flex items-center gap-3 mb-2">
            <Users className="w-6 h-6 text-purple-600" />
            <h2 className="text-gray-900">{t.title}</h2>
          </div>
        </div>

        <div className="space-y-4">
          <div className="bg-purple-50 border border-purple-200 rounded-lg p-5">
            <h3 className="text-sm text-gray-900 mb-3 flex items-center gap-2 font-semibold">
              <span className="text-xl">💬</span>
              {t.supportTitle}
            </h3>
            <p className="text-sm text-gray-700 leading-relaxed ml-7">
              {t.description}
            </p>
          </div>

          <div className="bg-blue-50 border border-blue-200 rounded-lg p-5">
            <h3 className="text-sm text-gray-900 mb-3 flex items-center gap-2 font-semibold">
              <span className="text-xl">⚖️</span>
              {t.powerDistributionTitle}
            </h3>
            <div className="space-y-3 ml-7">
              <div className="flex items-start gap-3">
                <span className="text-2xl">👥</span>
                <p className="text-sm text-gray-700 leading-relaxed">
                  {t.noModeratorGroup}
                </p>
              </div>
            </div>
          </div>

          <div className="bg-green-50 border border-green-200 rounded-lg p-5">
            <div className="flex items-start gap-3">
              <span className="text-2xl">🔍</span>
              <p className="text-sm text-gray-700 leading-relaxed">
                {t.transparency}
              </p>
            </div>
          </div>

          <div className="bg-orange-50 border border-orange-200 rounded-lg p-5">
            <div className="flex items-start gap-3">
              <span className="text-2xl">📝</span>
              <p className="text-sm text-gray-700 leading-relaxed">
                {t.votingProcess}
              </p>
            </div>
          </div>
        </div>

        <div className="mt-6 pt-4 border-t border-gray-200">
          <button
            onClick={onClose}
            className="w-full px-4 py-2 bg-purple-600 text-white rounded-lg hover:bg-purple-700"
          >
            {t.close}
          </button>
        </div>
      </div>
    </div>
  );
}